<?php
defined( 'ABSPATH' ) || exit;

class HRM_Security {

    public static function init() {
        // Initialization code for security checks
        // TODO: Implement file integrity checks or other security features if needed
    }

    public static function log( $event_type, $message ) {
        global $wpdb;
        
        $user_id = get_current_user_id();
        $ip = isset($_SERVER['REMOTE_ADDR']) ? $_SERVER['REMOTE_ADDR'] : '';
        
        $table_name = $wpdb->prefix . 'hrm_security_logs';
        
        // Ensure table exists before inserting to avoid errors if activation hook hasn't run recently
        // (Though usually we assume it exists)
        
        $wpdb->insert( 
            $table_name, 
            array(
                'event_type' => sanitize_text_field($event_type),
                'message'    => sanitize_textarea_field($message),
                'user_id'    => $user_id,
                'ip_address' => $ip,
                'created_at' => current_time( 'mysql' )
            ),
            array( '%s', '%s', '%d', '%s', '%s' )
        );
    }
}
